% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_rpowerstress.R
\name{cop_rpowerstress}
\alias{cop_rpowerstress}
\title{PCOPS version of restricted powerstress.}
\usage{
cop_rpowerstress(
  dis,
  theta = c(1, 1, 1),
  type = "ratio",
  weightmat = NULL,
  init = NULL,
  ndim = 2,
  itmaxi = 10000,
  ...,
  stressweight = 1,
  cordweight = 0.5,
  q = 1,
  minpts = ndim + 1,
  epsilon = 10,
  rang = NULL,
  verbose = 0,
  scale = "sd",
  normed = TRUE
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; the first two arguments are for kappa and lambda and should be equal (for the fitted distances and observed proximities), the third nu (for the weights). Internally the kappa and lambda are equated based on theta[1]. If a scalar is given it is recycled (so all elements of theta are equal); if a vector of length 2 is given, it gets expanded to c(theta[1],theta[1],theta[2]). Defaults to 1 1 1.}

\item{type}{MDS type. Defaults to "ratio".}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{number of dimensions of the target space}

\item{itmaxi}{number of iterations. default is 10000.}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.5}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the distances (min distance minus max distance). If NULL (default) the cordillera will be normed to each configuration's maximum distance, so an absolute value of goodness-of-clusteredness.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{scale}{should the configuration be scale adjusted}

\item{normed}{should the cordillera be normed; defaults to TRUE}
}
\value{
A list with the components
\itemize{
        \item stress: the stress1 value (sqrt(stress.m))
        \item stress.m: default normalized stress
        \item copstress: the weighted loss value
        \item OC: the Optics cordillera value
        \item parameters: the  explicit  parameters used for fitting (kappa=lambda, nu)
        \item fit: the returned object of the fitting procedure
        \item cordillera: the cordillera object
}
}
\description{
This is a power stress where kappa and lambda are free to vary but restricted to be equal, so the same exponent will be used for distances and dissimilarities. nu (for the weights) is also free.
}
\keyword{multivariate}
