% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_abundance.R
\name{set_abundance}
\alias{set_abundance}
\title{Set, create or modify columns with abundance information}
\usage{
set_abundance(
  .df,
  individualCount = NULL,
  organismQuantity = NULL,
  organismQuantityType = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{individualCount}{The number of individuals present}

\item{organismQuantity}{A number or enumeration value for the quantity of
organisms. Used together with \code{organismQuantityType} to provide context.}

\item{organismQuantityType}{The type of quantification system used for
\code{organismQuantity}.}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A \code{tibble} with the requested fields added/reformatted.
}
\description{
In some field methods, it is common to observe more than one individual
per observation; to observe abundance using non-integer measures such as
mass or area; or to seek individuals but not find them (abundance of zero).
As these approaches use different Darwin Core terms, this function assists in
specifying abundances to a \code{tibble} using Darwin Core Standard.

In practice this is no different from using \code{mutate()}, but gives some
informative errors, and serves as a useful lookup for how columns with
abundance information are represented in the Darwin Core Standard.
}
\details{
Examples of \code{organismQuantity} & \code{organismQuantityType} values:
\itemize{
\item 27 (\code{organismQuantity}) individuals (\code{organismQuantityType})
\item 12.5 (\code{organismQuantity}) \% biomass (\code{organismQuantityType})
\item r (\code{organismQuantity}) Braun-Blanquet Scale (\code{organismQuantityType})
\item many (\code{organismQuantity}) individuals (\code{organismQuantityType})
}
}
\examples{
df <- tibble::tibble(
  scientificName = c("Cacatua (Licmetis) tenuirostris",
                     "Cacatua (Licmetis) tenuirostris",
                     "Cacatua (Licmetis) tenuirostris"),
  n_obs = c(1, 3, 4)
  )

df |>
  set_abundance(individualCount = n_obs)

}
