% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codys2d.R
\name{codis2d}
\alias{codis2d}
\title{Two-dimensional codistribution spectroscopy.}
\usage{
codis2d(
  Mat,
  Ref = NULL,
  Wave = NULL,
  Time = NULL,
  Int = stats::splinefun,
  N = 2^ceiling(log2(NROW(Mat))),
  Norm = 1/(NROW(Mat) - 1),
  scaling = 0,
  corenumber = parallel::detectCores(),
  preview = FALSE
)
}
\arguments{
\item{Mat}{Numeric matrix containing the data which will be correlated;
'\emph{spectral variable}' by columns and '\emph{perturbation variables}'
by rows.}

\item{Ref}{Numeric vector containing a single spectrum, which will be
subtracted from \code{Mat} to generate dynamic spectra for 2D
correlation analysis. Default is \code{NULL} in which case the
\code{colMeans()} of \code{Mat} is used as reference. The length of
\code{Ref} needs to be equal to the number of columns in \code{Mat}.
2D codistribution spectroscopy is only strictly defined using the
perturbation-mean spectrum as reference spectrum. Thus, any deviation
from this definition can lead to unexpected results.}

\item{Wave}{Numeric vector containing the spectral variable. Needs to be
specified if column names of \code{Mat} are undefined.}

\item{Time}{Numeric vector containing the perturbation variables. If
specified, \code{Mat} will be interpolated to \code{N} equally spaced
perturbation variables using \code{Int}.}

\item{Int}{Function specifying how the dataset will be interpolated to give
\code{N} equally spaced perturbation variables. \code{\link[stats]{splinefun}}
(default) or \code{\link[stats]{approxfun}} can for example be used.}

\item{N}{Positive, non-zero integer specifying how many equally spaced
perturbation variables should be interpolated using \code{Int}. \code{N}
should be higher than 4. \code{corr2d} is fastest if \code{N} is a power
of 2.}

\item{Norm}{A number specifying how the correlation matrix should be
normalized.}

\item{scaling}{Positive real number used as exponent when scaling the dataset
with its standard deviation. Defaults to 0 meaning no scaling. 0.5
(\emph{Pareto scaling}) and 1 (\emph{Pearson scaling}) are commonly used
to enhance weak correlations relative to strong correlations. 2D
codistribution spectroscopy is only strictly defined without the usage
of any scaling techniques. Thus, any deviation from this definition can
lead to unexpected results.}

\item{corenumber}{Positive, non-zero integer specifying how many CPU cores
should be used for parallel fft computation.}

\item{preview}{Logical: Should a 3D preview of the asynchronous codistribution
spectrum be drawn at the end? Uses \code{\link[rgl]{persp3d}} from \pkg{rgl}
package.}
}
\value{
\code{codis2D} returns a list of class "corr2d" containing the complex
    codistribution matrix (\code{$FT}), the synchronous correlation spectrum
    ($corr), the used reference spectrum \code{$Ref1} and \code{$Ref2}, the 
    spectral variables \code{$Wave1} and \code{$Wave2} as well as the
    (interpolated) perturbation variables (\code{$Time}).
}
\description{
\code{codis2d} calculates the synchronous and asynchronous codistribution
    spectra.
}
\details{
\code{codis2d} calculates the the synchronous 2D correlation spectrum and
    uses the 2D spectrum to calculate the synchronous and asynchronous
    codistribution spectra. For parallelization the
    \code{\link[parallel]{parCapply}} function is used. Large input matrices
    (> 4000 columns) can lead to long calculation times depending on the
    number of cores used. Also note that the resulting matrix can become
    very large, adjust the RAM limit with \code{\link[utils]{memory.limit}}
    accordingly. For a detailed description of the underlying math see
    references.
}
\examples{
    testdata <- sim2ddata(C = NULL, Camp = NULL)
    codis <- codis2d(testdata, corenumber = 1)
    
    plot_corr2d(codis, Im(codis$FT),
                xlab = expression(paste("Wavenumber" / cm^-1)),
                ylab = expression(paste("Wavenumber" / cm^-1)))

}
\references{
I. Noda (2014) <DOI:10.1016/j.molstruc.2014.01.024>
}
\seealso{
For plotting of the resulting list containing the 2D codistribution
    spectra see \code{\link{plot_corr2d}} and \code{\link{plot_corr2din3d}}.
}
