% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{barplot2}
\alias{barplot2}
\title{barplot2 - Bar plot with upper error bars}
\usage{
barplot2(values, errors, lower = FALSE, flat = TRUE, ...)
}
\arguments{
\item{values}{A matrix of values}

\item{errors}{A matrix of values for upper error bar}

\item{lower}{Boolean, whether the lower error bar should be plotted, default FALSE}

\item{flat}{Boolean, whether the head of bars should be flat, default TRUE}

\item{...}{Arguments to be passed to the core _barplot_ function}
}
\value{
A plot
}
\description{
barplot2 - Bar plot with upper error bars
}
\examples{
values<-matrix(rnorm(10*4,mean=10),nrow=4,ncol=10)
errors<-matrix(runif(10*4),nrow=4,ncol=10)
colnames(values)<-colnames(errors)<-LETTERS[1:10]
barplot2(values,errors,main="Bar plot with error bars")
}
