% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cosimmr_pred_out.R
\name{plot.cosimmr_pred_out}
\alias{plot.cosimmr_pred_out}
\title{Plot different features of an object created from  \code{\link{cosimmr_ffvb}}.}
\usage{
\method{plot}{cosimmr_pred_out}(
  x,
  type = c("beta_histogram", "beta_boxplot", "prop_obs", "prop_density"),
  obs = 1,
  cov_name = NULL,
  binwidth = 0.05,
  alpha = 0.5,
  title = NULL,
  n_output = 3600,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cosimmr_output} created via
\code{\link{cosimmr_ffvb}}.}

\item{type}{The type of plot required. Can be one or more of 'isospace', 
'beta_histogram', 'beta_boxplot', 'prob_histogram', 'prob_density', 'covariates_plot'}

\item{obs}{The observation you wish to plot}

\item{cov_name}{The name of the covariate you wish to plot (for beta and covariate plots)}

\item{binwidth}{The width of the bins for the histogram. Defaults to 0.05}

\item{alpha}{The degree of transparency of the plots. Not relevant for
matrix plots}

\item{title}{The title of the plot.}

\item{n_output}{The number of theta samples you wish to plot with. Defaults to 3600}

\item{...}{Currently not used}
}
\value{
one or more of 'isospace', 'beta_histogram', 'beta_boxplot', 'prop_histogram', 'prop_density', or 'covariates_plot'
}
\description{
This function allows for 4 different types of plots of the simmr output
created from \code{\link{cosimmr_ffvb}}. The 
types are: plot of beta values
}
\details{
The matrix plot should form a necessary part of any SIMM analysis since it
allows the user to judge which sources are identifiable by the model.
Further detail about these plots is provided in the vignette.
}
\examples{

\donttest{
# A simple example with 10 observations, 2 tracers and 4 sources

# The data
data(geese_data_day1)

# Load into simmr
cosimmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ 1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)
# Plot
plot(cosimmr_1)


# FFVB run
cosimmr_1_out <- cosimmr_ffvb(cosimmr_1)

plot(cosimmr_1_out, type = c("isospace", "beta_hist"))
}
}
\seealso{
See  \code{\link{cosimmr_ffvb}} for 
creating objects suitable for this function, and many more examples. See 
also \code{\link{cosimmr_load}} for creating simmr objects, 
\code{\link{plot.cosimmr_input}} for creating isospace plots.
}
\author{
Emma Govan <emmagovan@gmail.com>>, Andrew Parnell
}
