% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_number_min.R
\name{gen_number_min}
\alias{gen_number_min}
\title{Generate a New Number for Minimizing Mutual Information}
\usage{
gen_number_min(x)
}
\arguments{
\item{x}{A contingency table (numeric matrix or table).}
}
\value{
A modified contingency table with minimized mutual information.
}
\description{
This function modifies a given contingency table by swapping values between two cells
in a way that minimizes the mutual information. The function randomly selects two cells
from the table and adjusts their values to reduce mutual information, returning the modified table.
}
\details{
This function performs the following steps:
\enumerate{
\item Randomly selects two rows and two columns from the table.
\item Ensures that the selected cells have non-zero values.
\item Adjusts the values of the selected cells in the table to minimize mutual information.
\item Returns the modified table with minimized mutual information.
}
}
\examples{
# Example usage with a contingency table:
pair_table <- table(c(1, 2, 2, 3), c(1, 1, 2, 2))
gen_number_min(pair_table)

}
