% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Drugs}
\alias{Drugs}
\title{Drugs}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 33 rows and 15 columns.
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Drugs
}
\value{
a tibble with 15 variables:
\describe{
  \item{primary_key}{Drugbank id}
  \item{other_keys}{Other identifiers that may be associated with the drug}
  \item{type}{	Either small molecule, or biotech. Biotech is used for any
  drug that is derived from living systems or organisms, usually composed of
   high molecular weight mixtures of protein, while small molecule describes
    a low molecular weight organic compound.}
  \item{name}{}
  \item{created}{Date that this drug was first added to DrugBank.}
  \item{updated}{Denotes when this drug was last updated in DrugBank.}
  \item{description}{Descriptions of drug chemical properties,
   history and regulatory status.}
  \item{cas_number}{The Chemical Abstracts Service (CAS) registry number
   assigned to the drug.}
  \item{\emph{unii}}{Unique Ingredient Identifier (UNII) of this drug.}
  \item{average_mass}{The weighted average of the isotopic masses of the
  drug}
  \item{state}{One of solid, liquid, or gas}
  \item{monoisotopic_mass}{The mass of the most abundant isotope of the drug}
  \item{synthesis_reference}{Citation for synthesis of the drug molecule.}
  \item{fda_label}{Contains a URL for accessing the uploaded United States Food
  and Drug Administration (FDA) Monograph for this drug.}
  \item{msds}{Contains a URL for accessing the Material Safety Data Sheet
  (MSDS) for this drug.}
}
}
\description{
Substance other than water and food that when administered by any route can
cause a physiological or biological change in the body.
}
\keyword{datasets}
