% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_intensity_area.R
\name{benchmark_area_intensity}
\alias{benchmark_area_intensity}
\title{Benchmark area intensity against regional data}
\usage{
benchmark_area_intensity(
  cf_area_intensity,
  region = NULL,
  benchmark_data = NULL
)
}
\arguments{
\item{cf_area_intensity}{A cf_area_intensity object}

\item{region}{Character. Region for comparison ("uruguay", "argentina", "brazil",
"new_zealand", "ireland", "global")}

\item{benchmark_data}{Named list. Custom benchmark data with mean and range}
}
\value{
Original object with added benchmarking information
}
\description{
Benchmark area intensity against regional data
}
\details{
Default regional benchmarks are illustrative placeholders for examples and testing.
For reporting, replace them with jurisdiction-specific or literature-based values.
}
\examples{
# Minimal, fast example
res <- calc_intensity_area(total_emissions = 50000, area_total_ha = 100)
benchmark_area_intensity(res, region = "global")

\donttest{
# Richer example
res <- calc_intensity_area(total_emissions = 90000, area_total_ha = 150, area_productive_ha = 140)
out <- benchmark_area_intensity(res, region = "uruguay")
# str(out$benchmarking)
}
}
