% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{obtain_u_set_mix2}
\alias{obtain_u_set_mix2}
\title{Obtain set of thresholds with high posterior density for the 2-component mixture model}
\usage{
obtain_u_set_mix2(
  df,
  powerlaw = FALSE,
  positive = FALSE,
  u_max = 2000L,
  log_diff_max = 11,
  alpha_init = 0.01,
  theta_init = exp(-1),
  shape_init = 0.1,
  sigma_init = 1,
  a_psiu = 0.001,
  b_psiu = 0.9,
  m_alpha = 0,
  s_alpha = 10,
  a_theta = 1,
  b_theta = 1,
  m_shape = 0,
  s_shape = 10,
  a_sigma = 1,
  b_sigma = 0.01
)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{powerlaw}{Boolean, is the power law (TRUE) or polylogarithm (FALSE, default) assumed?}

\item{positive}{Boolean, is alpha positive (TRUE) or unbounded (FALSE, default)?}

\item{u_max}{Positive integer for the maximum threshold}

\item{log_diff_max}{Positive real number, the value such that thresholds with profile posterior density not less than the maximum posterior density - \code{log_diff_max} will be kept}

\item{alpha_init}{Scalar, initial value of alpha}

\item{theta_init}{Scalar, initial value of theta}

\item{shape_init}{Scalar, initial value of shape parameter}

\item{sigma_init}{Scalar, initial value of sigma}

\item{a_psiu, b_psiu, m_alpha, s_alpha, a_theta, b_theta, m_shape, s_shape, a_sigma, b_sigma}{Scalars, hyperparameters of the priors for the parameters}
}
\value{
A list: \code{u_set} is the vector of thresholds with high posterior density, \code{init} is the data frame with the maximum profile posterior density and associated parameter values, \code{profile} is the data frame with all thresholds with high posterior density and associated parameter values, \code{scalars} is the data frame with all arguments (except df)
}
\description{
\code{obtain_u_set_mix2} computes the profile posterior density of the threshold u, and subsets the thresholds (and other parameter values) with high profile values i.e. within a certain value from the maximum posterior density. The set of u can then be used for \code{\link{mcmc_mix2}}.
}
\seealso{
\code{\link{mcmc_mix2_wrapper}} that wraps \code{obtain_u_set_mix2} and \code{\link{mcmc_mix2}}, \code{\link{obtain_u_set_mix1}} for the equivalent function for the TZP-power-law mixture model
}
