% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{dcf_add_noi_columns}
\alias{dcf_add_noi_columns}
\title{Explicitly standardise GEI and NOI columns in a Discounted Cash Flow (DCF) cash-flow table}
\usage{
dcf_add_noi_columns(cf_tab)
}
\arguments{
\item{cf_tab}{data.frame|tibble Cash-flow table for periods 0..N, typically
produced by \code{dcf_calculate()}.
Required columns: \code{opex} and either \code{gei} or
\code{net_operating_income}.}
}
\value{
A \code{tibble} with guaranteed numeric columns \code{gei} and
\code{noi}. Existing \code{noi} is preserved when present, but a warning is
emitted if it differs from \code{gei - opex} beyond a small tolerance.
}
\description{
Guarantees the presence of numeric columns \code{gei} and \code{noi} in a
cash-flow table, to make explicit the income base used for the unlevered
project IRR. In this package, \code{gei} denotes gross effective income
(after vacancy and rent-free effects) and \code{noi} is computed as
\code{gei - opex}.

The input may provide \code{gei} directly, or a legacy column
\code{net_operating_income} which is interpreted here as \code{gei}
(compatibility with earlier pipelines).
}
\examples{
# Minimal example with a legacy column name (net_operating_income interpreted as GEI)
cf_tab <- tibble::tibble(
  year = 0:2,
  net_operating_income = c(0, 120, 124),
  opex = c(0, 20, 21)
)
dcf_add_noi_columns(cf_tab)

# Example where GEI is provided explicitly and NOI is already present
cf_tab2 <- tibble::tibble(
  year = 0:2,
  gei  = c(0, 120, 124),
  opex = c(0, 20, 21),
  noi  = c(0, 100, 103)
)
dcf_add_noi_columns(cf_tab2)
}
