% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Fatality_df}
\alias{Fatality_df}
\title{Drunk Driving Laws and Traffic Deaths}
\format{
A data frame with 336 observations and 10 variables:
\describe{
  \item{state}{State identifier (integer).}
  \item{year}{Year of the observation (integer).}
  \item{mrall}{Motor vehicle fatality rate per 100,000 population (numeric).}
  \item{beertax}{Beer tax in dollars per gallon (numeric).}
  \item{mlda}{Minimum legal drinking age (MLDA) (numeric).}
  \item{jaild}{Indicator for mandatory jail sentence for drunk-driving (Factor: Yes/No).}
  \item{comserd}{Indicator for mandatory community service for drunk-driving (Factor: Yes/No).}
  \item{vmiles}{Vehicle miles traveled in billions (numeric).}
  \item{unrate}{Unemployment rate (numeric).}
  \item{perinc}{Per capita income in dollars (numeric).}
}
}
\source{
Panel data on drunk driving laws and traffic deaths in the U.S. for 48 states, 1982–1988.
}
\usage{
data(Fatality_df)
}
\description{
This dataset contains data on traffic fatalities and laws related to drunk driving across U.S. states.
It includes information on beer taxes, minimum legal drinking age (MLDA), and other socioeconomic factors
observed between 1982 and 1988.
}
\details{
The dataset name has been changed to 'Fatality_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the crimedatasets package and assists users
in identifying its specific characteristics. The suffix 'df' indicates that the dataset is stored as a traditional
data frame in R. The original content has not been modified in any way.
}
