% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromQuantiles.R
\name{Quantiles2LogisticNormal}
\alias{Quantiles2LogisticNormal}
\title{Convert Prior Quantiles to Logistic (Log) Normal Model}
\usage{
Quantiles2LogisticNormal(
  dosegrid,
  refDose,
  lower,
  median,
  upper,
  level = 0.95,
  logNormal = FALSE,
  parstart = NULL,
  parlower = c(-10, -10, 0, 0, -0.95),
  parupper = c(10, 10, 10, 10, 0.95),
  seed = 12345,
  verbose = TRUE,
  control = list(threshold.stop = 0.01, maxit = 50000, temperature = 50000, max.time =
    600)
)
}
\arguments{
\item{dosegrid}{(\code{numeric})\cr the dose grid.}

\item{refDose}{(\code{number})\cr the reference dose.}

\item{lower}{(\code{numeric})\cr the lower quantiles.}

\item{median}{(\code{numeric})\cr the medians.}

\item{upper}{(\code{numeric})\cr the upper quantiles.}

\item{level}{(\code{number})\cr the credible level of the (lower, upper) intervals.
Default is 0.95.}

\item{logNormal}{(\code{flag})\cr use the log-normal prior? If \code{FALSE} (default),
the normal prior for the logistic regression coefficients is used.}

\item{parstart}{(\code{numeric} or \code{NULL})\cr starting values for the parameters.
By default, these are determined from the medians supplied.}

\item{parlower}{(\code{numeric})\cr lower bounds on the parameters (intercept alpha
and the slope beta, the corresponding standard deviations and the correlation).}

\item{parupper}{(\code{numeric})\cr upper bounds on the parameters.}

\item{seed}{(\code{count})\cr seed for random number generation.}

\item{verbose}{(\code{flag})\cr should the function be verbose?}

\item{control}{(\code{list})\cr additional options for the optimisation routine,
see \code{\link[GenSA:GenSA]{GenSA::GenSA()}} for more details.}
}
\value{
A list with the best approximating \code{model}
(\code{\link{LogisticNormal}} or \code{\link{LogisticLogNormal}}), the resulting \code{quantiles},
the \code{required} quantiles and the \code{distance} to the required quantiles,
as well as the final \code{parameters} (which could be used for running the
algorithm a second time).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function uses generalized simulated annealing to optimize
a \code{\link{LogisticNormal}} model to be as close as possible
to the given prior quantiles.
}
