% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticNormalMixture-class}
\alias{LogisticNormalMixture-class}
\alias{.LogisticNormalMixture}
\alias{LogisticNormalMixture}
\alias{.DefaultLogisticNormalMixture}
\title{\code{LogisticNormalMixture}}
\usage{
LogisticNormalMixture(comp1, comp2, weightpar, ref_dose)

.DefaultLogisticNormalMixture()
}
\arguments{
\item{comp1}{(\code{ModelParamsNormal})\cr bivariate normal prior specification of
the first component. See \code{\link{ModelParamsNormal}} for more details.}

\item{comp2}{(\code{ModelParamsNormal})\cr bivariate normal prior specification of
the second component. See \code{\link{ModelParamsNormal}} for more details.}

\item{weightpar}{(\code{numeric})\cr the beta parameters for the weight of the
first component. It must a be a named vector of length 2 with names \code{a} and
\code{b} and with strictly positive values.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*}
(strictly positive number).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticNormalMixture}} is the class for standard logistic regression model
with a mixture of two bivariate normal priors on the intercept and slope parameters.
}
\details{
The covariate is the natural logarithm of the dose \eqn{x} divided by
the reference dose \eqn{x*}, i.e.:
\deqn{logit[p(x)] = alpha0 + alpha1 * log(x/x*),}
where \eqn{p(x)} is the probability of observing a DLT for a given dose \eqn{x}.
The prior
\deqn{(alpha0, alpha1) ~ w * Normal(mean1, cov1) + (1 - w) * Normal(mean2, cov2).}
The weight w for the first component is assigned a beta prior \code{B(a, b)}.
}
\section{Slots}{

\describe{
\item{\code{comp1}}{(\code{ModelParamsNormal})\cr bivariate normal prior specification of
the first component.}

\item{\code{comp2}}{(\code{ModelParamsNormal})\cr bivariate normal prior specification of
the second component.}

\item{\code{weightpar}}{(\code{numeric})\cr the beta parameters for the weight of the
first component. It must a be a named vector of length 2 with names \code{a} and
\code{b} and with strictly positive values.}

\item{\code{ref_dose}}{(\code{positive_number})\cr the reference dose.}
}}

\note{
The weight of the two normal priors is a model parameter, hence it is a
flexible mixture. This type of prior is often used with a mixture of a minimal
informative and an informative component, in order to make the CRM more robust
to data deviations from the informative component.

Typically, end-users will not use the \code{.DefaultLogisticNormalMixture()} function.
}
\examples{
my_model <- LogisticNormalMixture(
  comp1 = ModelParamsNormal(
    mean = c(-0.85, 1),
    cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2)
  ),
  comp2 = ModelParamsNormal(
    mean = c(1, 1.5),
    cov = matrix(c(1.2, -0.45, -0.45, 0.6), nrow = 2)
  ),
  weightpar = c(a = 1, b = 1),
  ref_dose = 50
)
}
\seealso{
\code{\link{ModelParamsNormal}}, \code{\link{ModelLogNormal}},
\code{\link{LogisticNormalFixedMixture}}, \code{\link{LogisticLogNormalMixture}}.
}
