% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{CohortSizeRange-class}
\alias{CohortSizeRange-class}
\alias{.CohortSizeRange}
\alias{CohortSizeRange}
\alias{.DefaultCohortSizeRange}
\title{\code{CohortSizeRange}}
\usage{
CohortSizeRange(intervals, cohort_size)

.DefaultCohortSizeRange()
}
\arguments{
\item{intervals}{(\code{numeric})\cr see slot definition.}

\item{cohort_size}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{CohortSizeRange}} is the class for cohort size based on dose range.
}
\section{Slots}{

\describe{
\item{\code{intervals}}{(\code{numeric})\cr a vector with the left bounds of the relevant
dose intervals.}

\item{\code{cohort_size}}{(\code{integer})\cr an integer vector with the cohort sizes
corresponding to the elements of \code{intervals}.}
}}

\note{
Typically, end users will not use the \code{.DefaultCohortSizeRange()} function.
}
\examples{
# Example for the rule having cohort of size 1 for doses <30
# and having cohort of size 3 for doses >=30.

my_size <- CohortSizeRange(intervals = c(0, 30), cohort_size = c(1, 3))
}
