% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{GeneralSimulationsSummary-class}
\alias{GeneralSimulationsSummary-class}
\alias{.GeneralSimulationsSummary}
\alias{GeneralSimulationsSummary}
\alias{.DefaultGeneralSimulationsSummary}
\title{\code{GeneralSimulationsSummary}}
\usage{
.DefaultGeneralSimulationsSummary()
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This class captures the summary of general simulations output. Note that objects
should not be created by users, therefore no initialization
function is provided for this class.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{numeric})\cr target toxicity interval}

\item{\code{target_dose_interval}}{(\code{numeric})\cr corresponding target dose interval}

\item{\code{nsim}}{(\code{integer})\cr number of simulations}

\item{\code{prop_dlts}}{(\code{ANY})\cr A numeric array (multi-dimensional) or list representing proportions of DLTs in the trials}

\item{\code{mean_tox_risk}}{(\code{numeric})\cr mean toxicity risks for the patients}

\item{\code{dose_selected}}{(\code{numeric})\cr doses selected as MTD}

\item{\code{tox_at_doses_selected}}{(\code{numeric})\cr true toxicity at doses selected}

\item{\code{prop_at_target}}{(\code{numeric})\cr Proportion of trials selecting target MTD}

\item{\code{dose_most_selected}}{(\code{numeric})\cr dose most often selected as MTD}

\item{\code{obs_tox_rate_at_dose_most_selected}}{(\code{numeric})\cr observed toxicity rate at dose most often selected}

\item{\code{n_obs}}{(\code{ANY})\cr A numeric array (multi-dimensional) or list representing number of patients overall.}

\item{\code{n_above_target}}{(\code{integer})\cr number of patients treated above target tox interval}

\item{\code{dose_grid}}{(\code{numeric})\cr the dose grid that has been used}

\item{\code{placebo}}{(\code{logical})\cr set to TRUE (default is FALSE) for a design with placebo}

\item{\code{any_backfilled}}{(\code{flag})\cr indicates if any backfill cohorts were used}

\item{\code{n_backfill}}{(\code{ANY})\cr number of patients in backfill cohorts (only if \code{any_backfilled=TRUE})}

\item{\code{backfill_doses}}{(\code{ANY})\cr list with doses used in backfill cohorts (only if \code{any_backfilled=TRUE})}
}}

\note{
Typically, end users will not use the \code{.DefaultGeneralSimulationsSummary()} function.
}
