% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kucoin.R
\name{kucoin_api_call}
\alias{kucoin_api_call}
\title{kucoin_api_call}
\usage{
kucoin_api_call(
  url,
  method,
  api_key,
  sig,
  time,
  passphrase,
  version,
  api_secret,
  query = NULL,
  timeout_seconds = 60
)
}
\arguments{
\item{url}{the full url for your Kucoin API call}

\item{method}{"GET" or "POST"}

\item{api_key}{your Kucoin API key}

\item{sig}{signature for use in your Kucoin API call. This can be generated
with the "kucoin_signature" function.}

\item{time}{a timestamp string formatted the way Kucoin requires. This can be
created with the "kucoin_time" function.}

\item{passphrase}{the passphrase you created when you created your Kucoin API
key.}

\item{version}{your API key version. This can be retrieved from your Kucoin
API console.}

\item{api_secret}{your Kucoin API secret.}

\item{query}{a named list containing your query parameters.}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns the data from your Kucoin API call.
}
\description{
kucoin_api_call
}
\examples{
\dontrun{
url <- "https://api.kucoin.com/api/v1/sub/user"
api_key <- "..."
api_secret <- "..."
time <- kucoin_time()
method <- "GET"
path <- "/api/v1/sub/user"
body <- ""
sig <- kucoin_signature(api_secret, time, method, path, body)
passphrase <- "..."
version <- "2"

accounts <- kucoin_api_call(url, method, api_key, sig, time, passphrase,
version, api_secret)}
}
