% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_lists_by_type_batch}
\alias{get_chemical_lists_by_type_batch}
\title{Get chemical lists by type batch search}
\usage{
get_chemical_lists_by_type_batch(
  type_list = NULL,
  Projection = "",
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{type_list}{A list of list types. This is a case sensitive parameter and
returns lists only for values of "federal", "international", "state", and
"other".}

\item{Projection}{Optional parameter controlling return type. It takes values
'chemicallistall' and 'chemicallistname' with the former as the default
value.}

\item{API_key}{The user-specified API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing information about lists that
meet the search criteria.
}
\description{
Get chemical lists by type batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemical lists by type
federal_state <- get_chemical_lists_by_type_batch(type_list = c('federal',
                                                                'state'))
\dontshow{\}) # examplesIf}
}
