% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_aggregate_records_by_dtxsid}
\alias{get_aggregate_records_by_dtxsid}
\title{Get aggregate records by DTXSID}
\usage{
get_aggregate_records_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.frame of aggregate record data by DTXSID.
}
\description{
Get aggregate records by DTXSID
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
#Pull aggregate records for BPA by DTXSID
bpa_agg_records <- get_aggregate_records_by_dtxsid(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
