% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionality.R
\name{count.substring.occurrences}
\alias{count.substring.occurrences}
\title{Count occurences of all possible substrings in one more strings.}
\usage{
count.substring.occurrences(strings, sortbylength = FALSE)
}
\arguments{
\item{strings}{a list or vector of character sequences}

\item{sortbylength}{logical indicating whether the substring columns should
be ordered according to the (decreasing) length of the substrings. Default
is to leave them in the original order in which they occur in the given
strings.}
}
\value{
A matrix with the original strings along rows and all substrings
of those strings along columns. The cell values indicate whether (and how
many times) the substring is contained in each of the strings.
}
\description{
Count occurences of all possible substrings in one more strings.
}
\examples{
count.substring.occurrences(c("asd", "asdd", "foo"))
}
