% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{read.dist}
\alias{read.dist}
\title{Read a distance matrix from a file or data frame.}
\usage{
read.dist(data, el1.column = 1, el2.column = 2, dist.columns = 3)
}
\arguments{
\item{data}{a filename, data frame or matrix}

\item{el1.column}{the column name or id specifying the first element}

\item{el2.column}{the column name or id specifying the second element}

\item{dist.columns}{the column name(s) or id(s) specifying the distance(s)
between the two corresponding elements}
}
\value{
a distance matrix (or list of distance matrixes when there is more
than one \code{dist.columns}) of type \code{matrix}
}
\description{
Read a distance matrix from a file or data frame.
}
\examples{
read.dist(cbind(c(1,1,1,2,2,3), c(2,3,4,3,4,4), 1:6, 6:1), dist.columns=c(3,4))
}
