% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-Path.R
\name{path_fn}
\alias{path_fn}
\title{Function Path}
\usage{
path_fn(x1, x2, fn, n = 50)
}
\arguments{
\item{x1}{starting column value of the path}

\item{x2}{ending column value of the path}

\item{fn}{function returning row value for a column input}

\item{n}{number of points along curve to calculate}
}
\value{
Nx2 matrix of \code{(row, column)} coordinates
}
\description{
Calculate the path within a grid of an user-supplied function.
}
\examples{
path_fn(x1=1, x2=10,
  function(x){sqrt(x)}
)

}
\seealso{
Other path-fitting functions: 
\code{\link{path_arc}()},
\code{\link{path_bezier}()},
\code{\link{path_circle}()},
\code{\link{path_ellipse}()},
\code{\link{path_fill}()},
\code{\link{path_intersection}()},
\code{\link{path_lerp}()},
\code{\link{path_ray}()},
\code{\link{path_rect}()},
\code{\link{path_shape}()}
}
\concept{path-fitting functions}
