% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tox_data.R
\name{tox_data}
\alias{tox_data}
\alias{ToxData-class}
\title{Prepare ecotox study data for fitting}
\usage{
tox_data(data, exposure = NULL)
}
\arguments{
\item{data}{a \code{data.frame} with at least two and at most four columns; the first
column must represent time, the second an observed quantity, the optional third
a trial or treatment ID, and the optional fourth the concentration during
the experiment}

\item{exposure}{an optional named list; names must correspond to trial IDs used for
the \code{data} argument; values can be numeric constants, data.frames, or an
\link{ExposureSeries} object}
}
\value{
a \code{ToxData} object
}
\description{
Takes ecotox study data in \emph{long-form} tabular format and prepares it for
parameter fitting. It supports extracting (optional) exposure concentration from
tabular data (useful for e.g. studies of acute toxicity) or exposure series
can also provided as individual time-series.
}
\section{Tabular format}{
The long-form tabular data must have at least two and at most four columns.
The position of the columns define what they represent, the column names
are ignored:
\itemize{
\item First column: time
\item Second column: observed quantity, e.g. number of individuals
\item (optional) Third column: Trial or treatment ID
\item (optional) Fourth column: Concentration
}

The first two columns, time and observed quantity, must always be present.
The third column, trial ID, is used to split the table by treatment so
that trials can later be handled individually. The fourth column, concentration,
can be used to also define the exposure level during the experiments.
}

\section{Explicit exposure series}{
As an alternative to defining concentrations along observed data, exposure
can also be passed as a list of exposure levels and series with
argument \code{exposure}. It can be used to provide exposure series for each
trial. The following object types are supported to define exposure:
\itemize{
\item Numerical constants
\item Tabular data, e.g. \code{data.frame}s
\item \link[=ExposureSeries]{exposure series} objects
}

If exposure is constant over time, exposure can be defined using a single
constant value. More complex exposure time-series can be defined using e.g.
\code{data.frame}s. Tabular data must have two columns with the first column
representing time and the second column representing exposure/concentrations.
}

\examples{
library(dplyr)

mydata <- schmitt2013 \%>\% tox_data()
}
