% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_radar}
\alias{plot_radar}
\title{Plot radar}
\usage{
plot_radar(data, label_x = "", label_y = "", colors = NULL)
}
\arguments{
\item{data}{two‑column data.frame: variable name and value}

\item{label_x}{x‑axis label (unused; variable names are shown around the circle)}

\item{label_y}{y‑axis label}

\item{colors}{line/fill color for the polygon}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Radar (spider) chart for a single profile of variables using polar coordinates.
}
\details{
Expects a two‑column data.frame with variable names in the first column and numeric values in the second.
}
\examples{
data <- data.frame(name = "Petal.Length", value = mean(iris$Petal.Length))
data <- rbind(data, data.frame(name = "Petal.Width", value = mean(iris$Petal.Width)))
data <- rbind(data, data.frame(name = "Sepal.Length", value = mean(iris$Sepal.Length)))
data <- rbind(data, data.frame(name = "Sepal.Width", value = mean(iris$Sepal.Width)))

grf <- plot_radar(data, colors="red") + ggplot2::ylim(0, NA)
plot(grf)
}
