% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing_inter.R
\name{smoothing_inter}
\alias{smoothing_inter}
\title{Smoothing by equal interval}
\usage{
smoothing_inter(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing_inter}
}
\description{
Discretize a numeric vector into \code{n} equal‑width intervals (robust bounds via boxplot whiskers)
and replace each value by the bin mean.
}
\examples{
data(iris)
obj <- smoothing_inter(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
\references{
Han, J., Kamber, M., Pei, J. (2011). Data Mining: Concepts and Techniques. (Discretization)
}
