% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_variational_ed.R
\name{autoenc_variational_ed}
\alias{autoenc_variational_ed}
\title{Variational Autoencoder - Encode-Decode}
\usage{
autoenc_variational_ed(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_variational_ed} object.
}
\description{
Creates a deep learning variational autoencoder (VAE) that encodes and decodes sequences
of observations. Wraps a PyTorch implementation.
}
\examples{
\dontrun{
# Requirements: Python with torch installed and reticulate configured.

# 1) Sample data
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)

# 2) Fit VAE encode-decode
ae <- autoenc_variational_ed(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)

# 3) Reconstruct inputs
X_hat <- daltoolbox::transform(ae, X)
mean((X - X_hat)^2)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_variational_ed.md
}
\references{
Kingma, D. P., & Welling, M. (2014). Auto-Encoding Variational Bayes.
}
