% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owsa.R
\name{plot.owsa}
\alias{plot.owsa}
\title{Plot a sensitivity analysis}
\usage{
\method{plot}{owsa}(
  x,
  txtsize = 12,
  col = c("full", "bw"),
  facet_scales = c("free_x", "free_y", "free", "fixed"),
  facet_nrow = NULL,
  facet_ncol = NULL,
  size = 1,
  n_x_ticks = 6,
  n_y_ticks = 6,
  basecase = NULL,
  ...
)
}
\arguments{
\item{x}{an owsa object}

\item{txtsize}{base text size in the plot}

\item{col}{either full-color ("full") or black and white ("bw")}

\item{facet_scales}{whether the x or y axes should be fixed.
See \code{\link[ggplot2]{facet_grid}} in the \code{ggplo2} package for
more details.}

\item{facet_nrow}{number of rows in plot facet.}

\item{facet_ncol}{number of columns in plot facet.
The default (NULL) is passed to \code{\link[ggplot2]{facet_wrap}},
which determines the number of rows and columns automatically.}

\item{size}{either point size (ptype = "point") and/or line size (ptype = "line")}

\item{n_x_ticks}{number of x-axis ticks}

\item{n_y_ticks}{number of y-axis ticks}

\item{basecase}{named list of specific values for each parameter to highlight
on the returned plot. Each list element must have the same name as the corresponding
parameter in the \code{owsa} object.}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} plot of the \code{owsa} object.
}
\description{
Plot a sensitivity analysis
}
