% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twsa.R
\name{plot.twsa}
\alias{plot.twsa}
\title{Two-way sensitivity analysis plot}
\usage{
\method{plot}{twsa}(
  x,
  maximize = TRUE,
  col = c("full", "bw"),
  n_x_ticks = 6,
  n_y_ticks = 6,
  txtsize = 12,
  basecase = NULL,
  ...
)
}
\arguments{
\item{x}{a twsa object}

\item{maximize}{If \code{TRUE}, plot of strategy with maximum expected outcome
(default); if \code{FALSE}, plot of strategy with minimum expected outcome}

\item{col}{either none, full color, or black and white}

\item{n_x_ticks}{number of x-axis ticks}

\item{n_y_ticks}{number of y-axis ticks}

\item{txtsize}{base text size}

\item{basecase}{named list of specific combination of param1 and param2 values to highlight
on the returned plot. Each list element must have the same name as the corresponding
parameter in the \code{owsa} object.}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} plot of the two-way sensitivity analysis.
}
\description{
Two-way sensitivity analysis plot
}
