% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.replicates.r
\name{gl.report.replicates}
\alias{gl.report.replicates}
\title{Identify replicated individuals}
\usage{
gl.report.replicates(
  x,
  loc_threshold = 100,
  perc_geno = 0.99,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  bins = 100,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{loc_threshold}{Minimum number of loci required to asses that two 
individuals are replicates [default 100].}

\item{perc_geno}{Mimimum percentage of genotypes in which two individuals 
should be the same [default 0.99].}

\item{plot.out}{Specify if plot is to be produced [default TRUE].}

\item{plot_theme}{User specified theme [default theme_dartR()].}

\item{plot_colors}{Vector with two color names for the borders and fill
[default two_colors].}

\item{bins}{Number of bins to display in histograms [default 100].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A list with three elements:
\itemize{
\item table.rep: A dataframe with pairwise results of percentage of same 
genotypes between two individuals, the number of loci used in the comparison 
and the missing data for each individual.
\item ind.list.drop: A vector of replicated individuals to be dropped.
Replicated individual with the least missing data is reported.
\item ind.list.rep: A list of of each individual that has replicates in the 
dataset, the name of the replicates and the percentage of the same genotype.
 }
}
\description{
Identify replicated individuals
}
\details{
This function uses an C++ implementation, so package Rcpp needs to be 
installed and it is therefore fast (once it has compiled the function after 
the first run).

Ideally, in a large dataset with related and unrelated individuals and 
several replicated individuals, such as in a capture/mark/recapture study, 
the first histogram should have four "peaks". The first peak should represent
 unrelated individuals, the second peak should correspond to second-degree 
 relationships (such as cousins), the third peak should represent 
 first-degree relationships (like parent/offspring and full siblings), and
  the fourth peak should represent replicated individuals. 
  
In order to ensure that replicated individuals are properly identified, it's
 important to have a clear separation between the third and fourth peaks in 
 the second histogram. This means that there should be bins with zero counts 
 between these two peaks.
}
\examples{
\donttest{
res_rep <- gl.report.replicates(platypus.gl, loc_threshold = 500, 
perc_geno = 0.85)
}
}
\seealso{
Other report functions: 
\code{\link{gl.report.bases}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.hwe}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.parent.offspring}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.sexlinked}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{report functions}
