% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparql.R
\name{dc_post_sparql}
\alias{dc_post_sparql}
\title{Execute a SPARQL Query via POST to the Data Commons API}
\usage{
dc_post_sparql(
  query,
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{query}{A character string containing a valid SPARQL query.}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list or JSON string, depending on \code{return_type}.
}
\description{
Sends a SPARQL query to the Data Commons SPARQL endpoint using a POST
request.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get a list of all cities with a particular property
query <- c(
  paste0(
    "SELECT DISTINCT ?subject ",
    "WHERE {?subject unDataLabel ?object . ?subject typeOf City} LIMIT 10"
  )
)
dc_post_sparql(query)

# Get a list of biological specimens
query <- c(
  paste0(
    "SELECT DISTINCT ?name ",
    "WHERE {?biologicalSpecimen typeOf BiologicalSpecimen . ",
    "?biologicalSpecimen name ?name} ",
    "ORDER BY DESC(?name)",
    "LIMIT 10"
  )
)
dc_post_sparql(query)
\dontshow{\}) # examplesIf}
}
