% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotrend.r
\name{plotrend}
\alias{plotrend}
\title{Function for building a scatterplot with a superposing
smoothed line}
\usage{
plotrend(
  x = x,
  y = y,
  col = "black",
  linecol = "red",
  lwd = 2,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector representing the X-axis variable.}

\item{y}{A numeric vector representing the Y-axis variable (response).}

\item{col}{A string specifying the color of the data points. The
default is "black".}

\item{linecol}{A string specifying the smooth line color. The
default is set to "red".}

\item{lwd}{the width of the smooth line to be drawn. The
default is set to \code{2}.}

\item{xlab}{(optional) A string specifying X-axis label.}

\item{ylab}{(optional) A string specifying Y-axis label.}

\item{...}{other graphical parameters (see par and
section 'Details' below).}
}
\value{
The function returns the above described graph.
}
\description{
The function creates a scatterplot with a superposing smoothed
line as a way to reveal any potential pattern between the
variables.
}
\details{
Notice that the smoothed-line is derived from a rather
standard algorithm (i.e., loess), implemented in the function
\code{smoothfit}, thus it is only an approximation.

Commonly used graphical parameters are:
\code{col} The colors for lines and points. Multiple colors can be specified so that each point can be given its own color. If there are fewer colors than points they are recycled in the standard fashion. Lines will all be plotted in the first colour specified.
\code{bg} a vector of background colors for open plot symbols, see points. Note: this is not the same setting as par("bg").
\code{pch} a vector of plotting characters or symbols: see points.
\code{cex} a numerical vector giving the amount by which plotting characters and symbols should be scaled relative to the default.
This works as a multiple of par("cex"). NULL and NA are
equivalent to 1.0. Note that this does not
affect annotation: see below.
\code{lty} a vector of line types, see \code{par}.
\code{cex.main}, \code{col.lab}, \code{font.sub}, etc settings for main- and sub-title and axis annotation, see title and \code{par}.
\code{lwd} a vector of line widths, see \code{par}.
}
\examples{
df <- datana::maple
head(df)
m1<-lm(leaf~dbh,data=df)
# Example 1, a residual plot
plotrend(x=df$dbh,y=residuals(m1))
abline(h=0)
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa
estadístico R:
una introducción aplicada.
Ediciones Universidad Mayor. Santiago, Chile. 170 p.
\url{https://eljatib.com}
}

\itemize{
\item Salas C, Stage AR, and Robinson AP. 2008. Modeling effects of
overstory density and competing
vegetation on tree height growth. Forest Science 54(1):107-122.
\doi{10.1093/forestscience/54.1.107}
}
}
\author{
Christian Salas-Eljatib
}
