% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000_globs.R
\name{value/missing-lists}
\alias{value/missing-lists}
\alias{cause_label_df}
\alias{missing_matchtable}
\alias{CODE_VALUE}
\alias{CODE_LABEL}
\alias{CODE_CLASS}
\alias{CODE_INTERPRET}
\alias{value_label_table}
\title{Data frame with labels for missing- and jump-codes
#' Metadata about value and missing codes}
\description{
\link{data.frame} with the following columns:
\itemize{
\item \code{CODE_VALUE}: \link{numeric} | \link{DATETIME} Missing or categorical code
(the number or date representing a
missing/category)
\item \code{CODE_LABEL}: \link{character} a label for the missing code or category
\item \code{CODE_CLASS}: \link{enum} JUMP | MISSING. For missing lists: Class of the
missing code.
\item \code{CODE_INTERPRET} \link{enum} I | P | PL | R | BO | NC | O | UH | UO | NE.
For missing lists: Class of the missing code
according to
\href{https://aapor.org/standards-and-ethics/standard-definitions/}{\code{AAPOR}}.
\item \code{resp_vars}: \link{character} For missing lists: optional, if a missing code
is specific for some
variables, it is listed for each such variable
with one entry in \code{resp_vars}, If \code{NA}, the
code is assumed shared among all variables.
For v1.0 metadata, you need to refer to
\code{VAR_NAMES} here.
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_Item_Level_Metadata.html#MISSING_LIST_TABLE}{Online}

\code{\link[=com_item_missingness]{com_item_missingness()}}

\code{\link[=com_segment_missingness]{com_segment_missingness()}}

\code{\link[=com_qualified_item_missingness]{com_qualified_item_missingness()}}

\code{\link[=com_qualified_segment_missingness]{com_qualified_segment_missingness()}}

\code{\link[=con_inadmissible_categorical]{con_inadmissible_categorical()}}

\code{\link[=con_inadmissible_vocabulary]{con_inadmissible_vocabulary()}}

\link{MISSING_LIST_TABLE}

\link{VALUE_LABEL_TABLE}

\link{STANDARDIZED_VOCABULARY_TABLE}

\link{cause_label_df}
}
