% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftChart.R
\name{GetLiftChart}
\alias{GetLiftChart}
\title{Retrieve lift chart data for a model for a data partition (see DataPartition)}
\usage{
GetLiftChart(
  model,
  source = DataPartition$VALIDATION,
  fallbackToParentInsights = FALSE
)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object like that returned by \code{GetModel}.}

\item{source}{character. The data partition for which data would be returned. Default is
\code{DataPartition$VALIDATION}. See \code{DataPartition} for details.}

\item{fallbackToParentInsights}{logical. If TRUE, this will return the lift chart data for the
model's parent if the lift chart is not available for the model and the model has a parent
model.}
}
\value{
data.frame with the following components:
\itemize{
  \item binWeight. Numeric: weight of the bin.  For weighted projects, the sum of the weights of
    all rows in the bin; otherwise, the number of rows in the bin.
  \item actual. Numeric: sum of actual target values in bin.
  \item predicted. Numeric: sum of predicted target values in bin.
}
}
\description{
Retrieve lift chart data for a model for a data partition (see DataPartition)
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetLiftChart(model, source = DataPartition$VALIDATION)
}
}
