% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{GetDeploymentSettings}
\alias{GetDeploymentSettings}
\title{Retrieves all settings for a deployed model.}
\usage{
GetDeploymentSettings(deployment)
}
\arguments{
\item{deployment}{An S3 object representing a model deployment, or the unique ID of such a
deployment.}
}
\value{
List representing the various settings to be configured on a
deployment, including:
\describe{
\item{associationId}{object. Information on association ID for tracking deployment accuracy.
See \code{\link[=GetDeploymentAssociationId]{GetDeploymentAssociationId()}}}
\item{challengerModels}{logical. Whether challenger models are enabled.}
\item{featureDrift}{logical. Whether feature drift tracking is enabled. See
\code{\link[=GetDeploymentDriftTrackingSettings]{GetDeploymentDriftTrackingSettings()}}}
\item{humility}{logical. Whether humility rules are enabled.}
\item{predictionIntervals}{object. Information on prediction intervals.}
\item{predictionWarning}{object. Information on prediction warning settings.}
\item{predictionsByForecastDate}{object. Information on predictions by forecast date.}
\item{predictionsDataCollection}{logical. Whether predictions data is stored.}
\item{targetDrift}{logical. Whether target drift tracking is enabled.}
\item{segmentAnalysis}{object. Information on segment analysis settings.}
}
}
\description{
Retrieves all settings for a deployed model.
}
\seealso{
Other deployment configuration functions: 
\code{\link{UpdateDeploymentSettings}()}
}
\concept{deployment configuration functions}
\keyword{internal}
