% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_ts}
\alias{check_ts}
\alias{assert_ts}
\title{Vérifie la conformité d'un objet ts}
\usage{
check_ts(x, .var.name = checkmate::vname(x), allow_mts = FALSE)

assert_ts(x, add = NULL, .var.name = checkmate::vname(x), allow_mts = FALSE)
}
\arguments{
\item{x}{Un objet ts unidimensionnel}

\item{.var.name}{Nom de l'objet à vérifier pour afficher dans les messages}

\item{allow_mts}{Booleen. Est ce que les objects \code{mts} sont acceptés ?}

\item{add}{Collection pour stocker les messages d'erreurs (Default is NULL)}
}
\value{
En sortie la fonction retourne l'objet \code{x} de manière invisible ou
une erreur.
}
\description{
Les fonctions \code{assert_ts} et \code{check_ts} vérifient qu'un objet ts
est bien conforme.
}
\details{
Les fonctions du package date4ts sont faites pour fonctionner
avec des times-series de fréquence mensuelle ou trimestrielle et basées sur
le système des mois, trimestres et années classiques.
On travaille avec des données numériques (integer, double ou logical) mais
les autres types atomic sont acceptés également.
On cherche donc à favoriser l'utilisation de séries temporelles classiques
utilisants des types atomiques.
Lorsque l'objet \code{x} en entrée est au mauvais format, une erreur est généré.

Selon le préfixe de la fonction :
\itemize{
\item si le check réussi :
\itemize{
\item la fonction \code{assert_ts} retourne l'objet \code{x} de manière invisible;
\item la fonction \code{check_ts} retourne le booléen \code{TRUE}.
}
\item si le check échoue :
\itemize{
\item la fonction \code{assert_ts} retourne un message d'erreur;
\item la fonction \code{check_ts} retourne une chaîne de caractère signalant le
problème.
}
}
}
\examples{
ts1 <- ts(1:100, start = 2010L, frequency = 12L)
ts2 <- ts(1:10, start = c(2020L, 4L), frequency = 4L)

assert_ts(ts1)
assert_ts(ts2)

check_ts(ts1)
check_ts(ts2)

# Exemples avec des erreurs

check_ts(1)
check_ts(ts(1:10, start = 2010L, frequency = 2L))
check_ts(1:10)

}
