#' This dataset
#' corresponds to a case study in the book "Sampling and Data Analysis Using R: Theory and Practice"
#'
#' A family library contains 1100 books. The owner is interested in exploring
#' some features of the existing books through a short survey. Thirty books
#' have been randomly selected, and four characteristics have been measured:
#' the number of pages (Page), weight in grams (Weight), surface area in square
#' inches (Surface), and type of each book (Type).
#'
#' @format A data frame with 30 rows and 4 variables:
#' \describe{
#'   \item{Page}{Number of pages for each book.}
#'   \item{Weight}{Weight of the book in grams.}
#'   \item{Surface}{Surface area of each book in square inches.}
#'   \item{Type}{Categorical variable defining whether this is a religious, science, or story book.}
#' }
#' @source Generated for the book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(case_study, package = "dauR")
#' head(case_study)
"case_study"



#' This dataset
#' was used in different chapters  of the book "Sampling and Data Analysis Using R: Theory and Practice"
#'
#' This dataset consists of a sample of eighty laborers from a large factory.
#'  Measurements on four variables, namely Gender, Age in years, Diastolic blood pressure and BMI are reported.
#'
#' @format A data frame with 80 rows and 4 variables:
#' \describe{
#'   \item{Gender}{Gender of individuals}
#'   \item{Age}{Age of the respondents}
#'   \item{Diastolic}{Diastolic blood pressure of the respondents}
#'   \item{BMI}{BMI of the respondents}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(Health, package = "dauR")
#' head(Health)
"Health"




#' This dataset
#' refers to the concept of ordinal data
#'
#' A survey was conducted on a group of 15 students about teaching-learning environment of an institution.
#' One part of the survey (comprises five questions) was dedicated for opinions about one recently completed course.
#'
#' @format A data frame with 15 rows and 5 variables, all in likert-scale:
#' \describe{
#'   \item{good_exp}{Question about whether this was a good experience}
#'   \item{disturb_free}{Question about whether enjoyed disturb-free internet connection }
#'   \item{support}{Question about whether got support from my institution }
#'   \item{instructors}{Question about whether instructors were good in distant teaching and new technology}
#'   \item{better}{Question about whetherit is better than in-class teaching }
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(likert_data, package = "dauR")
#' head(likert_data)
"likert_data"


#' This dataset
#' demonstrates the concept of Mediation, Moderation & Confounding
#'
#' The dataset contains 200 observations and five variables,
#' namely reading_time, vocab, test_score, access_resources and read_motiv.
#'
#' @format A data frame with 200 rows and five variables:
#' \describe{
#'   \item{reading_time}{Time spent in reading}
#'   \item{vocab}{Measure of richness of vocubulary}
#'   \item{test_score}{Score from the }
#'   \item{access_resources}{Access to Resources }
#'   \item{read_motiv}{Measure of motivation for reading}

#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(reading, package = "dauR")
#' head(reading)
"reading"



#' This dataset is used to
#' illustrate the concept of contingency table
#'
#' This dataset shows smoking habit of 198 drivers of three types of vehicles. The types of vehicles are Bus, Truck and Taxi.
#'Here our aim is to find whether there is any association between smoking habit and the occupation type, represented here by the type of vehicle driven.
#'
#' @format A data frame with 198 rows and 2 variables:
#' \describe{
#'   \item{Class}{Type of vehicle driven}
#'   \item{SmokingStatus}{Categorial verible, showing whether smoker of non-smoker}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(smoke_class, package = "dauR")
#' head(smoke_class)
"smoke_class"




#' This dataset
#' illustrates the application of two-way ANOVA
#'
#' A researcher seeks to investigate whether an individual’s life satisfaction (happiness) is associated with gender and working status.
#' The variable Gender includes two categories:  Male and Female, while Working_Status comprises three categories: Self-employed,
#' Student and Job. A random sample of ten participants was selected from each category. Life satisfaction was measured on a scale ranging from 0 to 100, with higher scores indicating greater happiness.
#' Therefore, the dependent variable is life satisfaction (happiness), and the independent variables are gender and working status.
#'
#' @format A data frame with 60 rows and 3 variables:
#' \describe{
#'   \item{Happiness}{Measurement of happiness}
#'   \item{Gender}{Gender of individuals}
#'   \item{Working_Status}{Working status of individuals. The classes are "Job", "Self_employed" and "Student"}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(twoway, package = "dauR")
#' head(twoway)
"twoway"




#' The
#' datasets weight1 and weight2 correspond to pair-wise observations
#'
#' This dataset shows weight of 16 individuals before taking medication.
#'
#' @format A vector of 16 observations:
#' \describe{
#'   \item{weight1}{weight of individuals}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(weight1, package = "dauR")
#' head(weight1)
"weight1"




#' The
#' datasets weight1 and weight2 correspond to pair-wise observations
#'
#' This dataset shows weight of 16 individuals after taking medication.
#'
#' @format A vector of 16 observations:
#' \describe{
#'   \item{weight2}{weight of individuals}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(weight2, package = "dauR")
#' head(weight2)
"weight2"




#' This dataset
#' is to demonstrate the concept of PCA and Factor Analysis
#'
#' The dataset contains nine variables and 20 recently graduates from university and college.
#' For a high-school job, students sat for exam on 7 subjects and then appeared for oral (viva-voce) exam.
#' The subjects are Math, Physics, Chemistry, Statistics, Bengali literature, English literature and History.
#'
#' @format A dataframe with 9 variables and 20 observations:
#' \describe{
#'   \item{ID}{Serial number}
#'   \item{Group}{Whether a student is from science or humanities background}
#'   \item{Math}{Score in Mathematics}
#'   \item{Physics}{Scores in Physics}
#'   \item{Chemistry}{Score in Chemistry}
#'   \item{Statistics}{Score in Statistics}
#'   \item{English}{Score in English}
#'   \item{Bengali}{Score in Bengali}
#'   \item{History}{Score in History}
#'   \item{Viva}{Score in Viva-voce}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(students_data, package = "dauR")
#' head(students_data)
"students_data"



#' This dataset
#' is to demonstrate the concept of Survival Analysis
#'
#' This dataset is about an engineering firm which monitors industrial machines over time to understand how long
#'they operate before experiencing a mechanical failure. Each machine is tracked from installation until either
#'it fails or the study period ends. The record includes each machine’s operating age (in years) and maintenance type of whether it receives regular maintenance or on-demand maintenance.
#'
#' @format A dataframe with 4 variables and 223 observations:
#' \describe{
#'   \item{time}{Time to malfunction (in days)	}
#'   \item{status}{Failure indicator (1 = still operational/censored, 2 = malfunctioned)}
#'   \item{age}{Age of machine at installation (in years)}
#'   \item{maintenance}{Maintenance type (1 = On-demand, 2 = Regular)}
#' }
#' @source Generated for book "Sampling and Data Analysis Using R: Theory and Practice" by Dr. Mohammad Shahidul Islam
#' @examples
#' data(eng_data, package = "dauR")
#' head(eng_data)
"eng_data"




