% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_dccmidas}
\alias{plot_dccmidas}
\title{Plot method for 'dccmidas' class}
\usage{
plot_dccmidas(
  x,
  K_c = NULL,
  vol_col = "black",
  long_run_col = "red",
  cex_axis = 0.75,
  LWD = 2,
  asset_sub = NULL
)
}
\arguments{
\item{x}{An object of class 'dccmidas', that is the result of a call to \code{\link{dcc_fit}}.}

\item{K_c}{\strong{optional} Number of (lagged) realizations to use for the long-run correlation, , if 'corr_model' is "DCCMIDAS"}

\item{vol_col}{\strong{optional} Color of the volatility and correlation plots. "black" by default}

\item{long_run_col}{\strong{optional} Color of the long-run correlation plots, if present. "red" by default}

\item{cex_axis}{\strong{optional} Size of the x-axis. Default to 0.75}

\item{LWD}{\strong{optional} Width of the plotted lines. Default to 2}

\item{asset_sub}{\strong{optional} Numeric vector of selected assets to consider for the plot. NULL by default}
}
\value{
No return value, called for side effects
}
\description{
Plots of the conditional volatilities on the main diagonal and of the conditional correlations on the
extra-diagonal elements.
}
\examples{
\donttest{
require(xts)
# close to close daily log-returns
r_t_s<-diff(log(sp500['2010/2019'][,3]))
r_t_s[1]<-0
r_t_n<-diff(log(nasdaq['2010/2019'][,3]))
r_t_n[1]<-0
r_t_f<-diff(log(ftse100['2010/2019'][,3]))
r_t_f[1]<-0
db_m<-merge.xts(r_t_s,r_t_n,r_t_f)
db_m<-db_m[complete.cases(db_m),]
colnames(db_m)<-c("S&P500","NASDAQ","FTSE100")
# list of returns
r_t<-list(db_m[,1],db_m[,2],db_m[,3])
# estimation
K_c<-144
N_c<-36
cdcc_est<-dcc_fit(r_t,univ_model="sGARCH",distribution="norm",
corr_model="DCCMIDAS",N_c=N_c,K_c=K_c)
plot_dccmidas(cdcc_est,K_c=144)
}
}
