% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamaska.R
\docType{data}
\name{yamaska_net}
\alias{yamaska_net}
\title{River network for the Yamaska watershed}
\format{
A \code{river_net} object with:
\describe{
\item{Nodes}{
\describe{
\item{geometry}{the geometry list column of the node point features}
\item{pass_1}{the passability of nodes in the network from 0 (impassable) to 1}
\item{pass_2}{the binary passability of nodes in the network, 0 if a barrier and 1 otherwise}
\item{type}{the type of the node: topological, barrier, or outlet}
}
}
\item{Edges}{
\describe{
\item{from}{the row index of the origin node of the edge feature}
\item{to}{the row index of the destination node of the edge feature}
\item{qual}{a simulated weighting based on habitat quality of features}
\item{riv_length}{length of edge features in meters}
\item{rivID}{unique river feature integer ID}
\item{geometry}{the geometry list column of edge line features}
}
}
}
}
\source{
\url{https://www.donneesquebec.ca/recherche/dataset/grhq}

\url{https://www.donneesquebec.ca/recherche/dataset/structure}
}
\usage{
yamaska_net
}
\description{
A spatial \code{river_net} object extending the \code{tidygraph} representation of
spatial graphs. Nodes represent confluences, river endpoints, barriers, and
the outlet. Edges represent stream reaches. Spatial features are projected to
EPSG:32198.
}
\keyword{datasets}
