% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-model-specification.R
\name{dcm_specification}
\alias{dcm_specification}
\title{S7 model specification class}
\usage{
dcm_specification(
  qmatrix = list(),
  qmatrix_meta = list(),
  measurement_model = measurement(),
  structural_model = structural(),
  priors = dcmprior()
)
}
\arguments{
\item{qmatrix}{A cleaned Q-matrix, as returned by
\code{\link[rdcmchecks:check_qmatrix]{rdcmchecks::clean_qmatrix()}}.}

\item{qmatrix_meta}{A list of Q-matrix metadata consisting of the other
(not Q-matrix) elements returned by \code{\link[rdcmchecks:check_qmatrix]{rdcmchecks::clean_qmatrix()}}.}

\item{measurement_model}{A \link[=measurement-model]{measurement model} object.}

\item{structural_model}{A \link[=structural-model]{structural model} object.}

\item{priors}{A \link[=prior]{prior} object.}
}
\value{
A \code{dcm_specification} object.
}
\description{
The \code{dcm_specification} constructor is exported to facilitate the defining
of methods in other packages. We do not expect or recommend calling this
function directly. Rather, to create a model specification, one should use
\code{\link[=dcm_specify]{dcm_specify()}}.
}
\examples{
qmatrix <- tibble::tibble(
  att1 = sample(0:1, size = 15, replace = TRUE),
  att2 = sample(0:1, size = 15, replace = TRUE),
  att3 = sample(0:1, size = 15, replace = TRUE),
  att4 = sample(0:1, size = 15, replace = TRUE)
)

dcm_specification(qmatrix = qmatrix,
                  qmatrix_meta = list(attribute_names = paste0("att", 1:4),
                                      item_identifier = NULL,
                                      item_names = 1:15),
                  measurement_model = lcdm(),
                  structural_model = unconstrained(),
                  priors = default_dcm_priors(lcdm(), unconstrained()))
}
\seealso{
\code{\link[=dcm_specify]{dcm_specify()}}.
}
