% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Create a scatter plot.}
\usage{
scatterPlot(
  data,
  x,
  y,
  col = "crimson",
  size = 2,
  xticks = NULL,
  yticks = NULL,
  xtitle = NULL,
  xtitleFontSize = 16,
  ytitle = NULL,
  ytitleFontSize = 16,
  title = NULL,
  titleFontSize = 22,
  stroke = NULL,
  strokeWidth = NULL,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "#CAD0D3",
  opacity = 1,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the quantitative variables.}

\item{x}{The x-variable to consider.}

\item{y}{The y-variable to consider.}

\item{col}{The color of the dots. Defaults to 'crimson'.}

\item{size}{The size of the dots. Defaults to 2.}

\item{xticks}{Optional. The number of x-axis ticks to consider.}

\item{yticks}{Optional. The number of y-axis ticks to consider.}

\item{xtitle}{Optional. the title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 16.}

\item{title}{Optional. the title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{stroke}{Optional. the stroke color of the dots.}

\item{strokeWidth}{Optional. the stroke width of the dots.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "#CAD0D3" HEX color.}

\item{opacity}{The color opacity of the dots (from 0 to 1). Defaults to 1.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. the width of the SVG output.}

\item{height}{Optional. the height of the SVG output.}
}
\value{
A SVG scatter plot.
}
\description{
Create a scatter plot.
}
\examples{

scatterPlot(
  data = mtcars,
  x = "mpg",
  y = "wt"
  )

}
