% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dTTE_plotting.R
\name{plot_SMD_matching}
\alias{plot_SMD_matching}
\alias{plot_Equipoise_matching}
\alias{plot_SMD_stratification}
\alias{plot_Equipoise_stratification}
\alias{plot_SMD_weighting}
\alias{plot_Equipoise_weighting}
\alias{plotPs}
\alias{plotCovariateBalanceOfTopVariables}
\title{Plot Standardized Mean Differences (SMD) for Matching}
\usage{
plot_SMD_matching(m.out)

plot_Equipoise_matching(data, m.out)

plot_SMD_stratification(stratifiedPop, xvars)

plot_Equipoise_stratification(data)

plot_SMD_weighting(data)

plot_Equipoise_weighting(data)

plotPs(
  data,
  unfilteredData = NULL,
  scale = "preference",
  type = "density",
  binWidth = 0.05,
  targetLabel = "Target",
  comparatorLabel = "Comparator",
  showCountsLabel = FALSE,
  showAucLabel = FALSE,
  showEquiposeLabel = FALSE,
  equipoiseBounds = c(0.3, 0.7),
  unitOfAnalysis = "subjects",
  title = NULL,
  fileName = NULL
)

plotCovariateBalanceOfTopVariables(
  balance,
  n = 20,
  maxNameWidth = 100,
  title = NULL,
  fileName = NULL,
  beforeLabel = "before matching",
  afterLabel = "after matching"
)
}
\arguments{
\item{unfilteredData}{A logical indicating whether to include unfiltered data in the plot.}
\item{maxNameWidth}{An integer specifying the maximum width for variable names.}

\item{m.out}{The output from `MatchIt`, containing matched data.}

\item{data}{A dataset containing treatment and propensity scores.}

\item{stratifiedPop}{The dataset containing stratified propensity scores.}

\item{xvars}{The covariate names to assess balance.}

\item{scale}{The scale to use: "preference" or "propensity".}

\item{type}{The type of plot: "density", "histogramCount", or "histogramProportion".}

\item{binWidth}{The bin width for histograms (default = 0.05).}

\item{targetLabel}{Label for the treated group.}

\item{comparatorLabel}{Label for the control group.}

\item{showCountsLabel}{Logical; whether to show sample counts.}

\item{showAucLabel}{Logical; whether to show AUC.}

\item{showEquiposeLabel}{Logical; whether to indicate equipoise range.}

\item{equipoiseBounds}{A numeric vector of two values defining the equipoise range (default = c(0.3, 0.7)).}

\item{unitOfAnalysis}{Unit label for counts (e.g., "subjects").}

\item{title}{Optional title for the plot.}

\item{fileName}{Optional file name to save the plot.}

\item{balance}{A data frame containing standardized mean differences.}

\item{n}{Number of top covariates to display.}

\item{beforeLabel}{Label for pre-matching imbalance.}

\item{afterLabel}{Label for post-matching balance.}
}
\value{
A `ggplot2` object showing balance improvement after matching.
}
\description{
Generates a plot of standardized mean differences before and after propensity score matching.

Generates a plot showing the distribution of preference scores to assess equipoise after matching.

Generates an SMD plot to compare balance before and after stratification.

Generates a plot showing the distribution of preference scores to assess equipoise after stratification.

Generates an SMD plot to compare balance before and after propensity score weighting.

Generates a plot showing the distribution of preference scores to assess equipoise after weighting.

Creates a plot of propensity score distributions using density or histogram visualization.

Creates a plot showing the top covariates with the largest standardized mean differences before and after matching.
}
