% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca.R
\name{cca}
\alias{cca}
\title{Canonical correlation analysis}
\usage{
cca(X, Y, k = min(dim(X), dim(Y)), lambda.x = NULL, lambda.y = NULL)
}
\arguments{
\item{X}{first matrix (n x p1)}

\item{Y}{first matrix (n x p2)}

\item{k}{number of canonical components to return}

\item{lambda.x}{optional shrinkage parameter for estimating covariance of X. If NULL, estimate from data.}

\item{lambda.y}{optional shrinkage parameter for estimating covariance of Y. If NULL, estimate from data.}
}
\value{
statistics summarizing CCA
}
\description{
Canonical correlation analysis that is scalable to high dimensional data.  Uses covariance shrinkage and algorithmic speed ups to be linear time in p when p > n.
}
\details{
Results from standard CCA are based on the SVD of \eqn{\Sigma_{xx}^{-\frac{1}{2}} \Sigma_{xy} \Sigma_{yy}^{-\frac{1}{2}}}.

Avoids computation of \eqn{\Sigma_{xx}^{-\frac{1}{2}}} by using eclairs.  Avoids cov(X,Y) by framing this as a matrix product that can be distributed. Uses low rank SVD.
Other regularized CCA adds lambda to covariance like Ridge. Here it is a mixture
}
\keyword{internal}
