% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LFT.R
\name{LFT}
\alias{LFT}
\title{LFT (Möbius transformation)}
\usage{
LFT(a = NULL, dtype = "float32")
}
\arguments{
\item{a}{vector of four complex numbers describing the Möbius transformation}

\item{dtype}{data type}
}
\value{
\code{LFT} returns a list containing a list with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the Möbius transformation using \code{TensorFlow}}
 \item{"fR"}{Same as \code{f} but uses \code{R}}
 \item{"fMC"}{Same as \code{f} but does it in parallel for several inputs index by the first dimension of the tensor}
 \item{"r"}{The number of basis functions (fixed to 1 in this case)}
 \item{"trans"}{The transformation applied to the weights before estimation (in this case the identity)}
 \item{"fix_weights"}{Flag indicating whether the weights are fixed or not (TRUE for LFTs)}
 \item{"name"}{Name of layer}
 \item{"pars"}{List of parameters describing the Möbius transformation as \code{TensorFlow} objects}
}
}
\description{
Sets up a Möbius transformation unit
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
layer <- LFT()
 }
}
}
