% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deflate.R
\name{deflate}
\alias{deflate}
\title{Deflate Nominal Brazilian Reais Using Various Price Indexes}
\usage{
deflate(nominal_values, nominal_dates, real_date, index = c("ipca",
  "igpm", "igpdi", "ipc", "inpc"))
}
\arguments{
\item{nominal_values}{A \code{numeric} vector containing nominal Brazilian Reais to deflate.}

\item{nominal_dates}{A \code{Date} vector with corresponding nominal dates (i.e., when nominal values were measured).
Values are set to the previous month, following the
standard methodology used by the \href{https://www3.bcb.gov.br/CALCIDADAO/publico/metodologiaCorrigirIndice.do?method=metodologiaCorrigirIndice}{Brazilian Central Bank}.}

\item{real_date}{A value indicating the reference date to deflate nominal values in the format
'MM/YYYY' (e.g., '01/2018' for January 2018).}

\item{index}{Indicates the price index used to deflate nominal Reais. Valid options are: \code{ipca}, \code{igpm},
\code{igpdi}, \code{ipc}, and \code{inpc}.}
}
\value{
A \code{numeric} vector.
}
\description{
\code{deflate()} uses data from the Brazilian Institute for Applied Economic Research's API (IPEADATA) to adjust nominal Brazilian Reais for inflation.
}
\details{
Each one of the five price indexes included
in the function are maintained by two Brazilian agencies: IPCA and INPC indexes are maintained by Brazilian Institute of Geography and Statistics (IBGE);
IGP-M, IGP-DI, and IPC are maintained by Getulio Vargas Foundation (FGV). For an overview of the indexes' methodologies and covered periods, check the Brazilian Central Bank official \href{https://www.bcb.gov.br/conteudo/home-en/FAQs/FAQ\%2002-Price\%20Indices.pdf}{FAQ}.
}
\examples{
\dontrun{
# Use IPCA index to deflate a vector of nominal Brazilian Reais
reais <- rep(100, 5)
actual_dates <- seq.Date(from = as.Date("2001-01-01"), to = as.Date("2001-05-01"), by = "month")

deflate(reais, actual_dates, "01/2018", "ipca")

# Using IGP-M index
deflate(reais, actual_dates, "01/2018", "igpm")
}

}
\references{
For more information on the Brazilian Institute for Applied Economic Research's API, please check (in Portuguese):
\url{http://www.ipeadata.gov.br/}.
}
