% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abgd_tbl.R
\name{abgd_tbl}
\alias{abgd_tbl}
\title{A Command-Line Interface for ABGD - Automatic Barcode Gap Discovery}
\source{
Puillandre N., Lambert A., Brouillet S., Achaz G. 2012. ABGD, Automatic Barcode
Gap Discovery for primary species delimitation. Molecular Ecology 21(8):1864-77.
}
\usage{
abgd_tbl(
  infile,
  exe = NULL,
  haps = NULL,
  slope = 1.5,
  model = 3,
  outfolder = NULL,
  webserver = NULL,
  delimname = "abgd"
)
}
\arguments{
\item{infile}{Path to fasta file.}

\item{exe}{Path to an ABGD executable.}

\item{haps}{Optional. A vector of haplotypes to keep into the \code{\link[tibble:tbl_df-class]{tbl_df}}.}

\item{slope}{Numeric. Relative gap width (slope). Default to 1.5.}

\item{model}{An integer specifying evolutionary model to be used. Available options are:
\itemize{
\item 0: Kimura-2P
\item 1: Jukes-Cantor (default)
\item 2: Tamura-Nei
\item 3: simple distance (p-distance)
}}

\item{outfolder}{Path to output folder. Default to NULL. If not specified, a temporary location is used.}

\item{webserver}{A .txt file containing ABGD results obtained from a webserver. Default to NULL.}

\item{delimname}{Character. String to rename the delimitation method in the table. Default to 'abgd'.}
}
\value{
an object of class \code{\link[tibble:tbl_df-class]{tbl_df}}
}
\description{
\code{abgd_tbl()} returns species partition hypothesis estimated by ABGD software
(https://bioinfo.mnhn.fr/abi/public/abgd/).
}
\details{
\code{abgd_tbl()} relies on \link[base:system]{system} to invoke ABGD software through
a command-line interface. Hence, you must have the software available as an executable file on
your system in order to use this function properly.
\code{abgd_tbl()} saves all output files in \code{outfolder} and imports the first recursive partition
file generated to \code{Environment}.
Alternatively, \code{abgd_tbl()} can parse a .txt file obtained from a webserver such as
(https://bioinfo.mnhn.fr/abi/public/abgd/abgdweb.html).
}
\examples{
\donttest{

#' # get path to fasta file
path_to_file <- system.file("extdata/geophagus.fasta", package = "delimtools")

# run ABGD
abgd_df <- abgd_tbl(
  infile = path_to_file,
  exe = "/usr/local/bin/abgd",
  model = 3,
  slope = 0.5,
  outfolder = NULL
)

# check
abgd_df
}

}
\author{
N. Puillandre,  A. Lambert,  S. Brouillet,  G. Achaz
}
