% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.kmm}
\alias{print.kmm}
\title{Print a \code{kmm} object}
\usage{
\method{print}{kmm}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{Object of class \code{kmm}.}

\item{digits}{Number of digits to use when printing the output.}

\item{...}{further arguments on how to format the number of digits.}
}
\value{
\code{invisble} The inputted \code{kmm} object.
}
\description{
Print a \code{kmm} object
}
\examples{
set.seed(123)
# Fit model
dr <- kmm(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
kmm(numerator_small, denominator_small,
    nsigma = 5, ncenters = 100, nfold = 10,
    constrained = TRUE)

}
\seealso{
\code{\link{print}}, \code{\link{kmm}}
}
