#' @keywords internal

compute_D_residual <- function(D, group_sizes, weights = density.weights, sigma2 = sigma2_hat) {
  n <- sum(group_sizes)
  k <- length(group_sizes)

  G <- matrix(0, nrow = n, ncol = k)
  start_idx <- 1
  for (i in seq_along(group_sizes)) {
    end_idx <- start_idx + group_sizes[i] - 1
    G[start_idx:end_idx, i] <- 1
    start_idx <- end_idx + 1
  }

  W_D <- diag(weights)
  n_w <- colSums(G * weights)
  N_w <- diag(n_w)

  E_R <- (diag(n) - G %*% solve(N_w) %*% t(G) %*% W_D) %*% D %*% (diag(n) - W_D %*% G %*% solve(N_w) %*% t(G))

  D_residual <- matrix(0, nrow = n, ncol = n)
  for (i in 1:n) {
    for (j in 1:n) {
      D_residual[i, j] <- (2 * E_R[i, j] - E_R[i, i] - E_R[j, j]) / 2
    }
  }

  return(D_residual)
}
