\name{agg.wtd.mean}
\alias{agg.wtd.mean}

\title{
Aggregated Weighted Mean
}

\description{
Splits the data into subsets (according to the levels of a factor) and computes the weighted mean for each
}

\usage{
agg.wtd.mean(x, by, weights = NULL, na.rm = FALSE)
}

\arguments{
  \item{x}{numeric vector or data frame of numeric vectors}
  \item{by}{factor used to split the data}  
  \item{weights}{numeric vector of weights. If NULL (default), uniform weights (i.e. all equal to 1) are used.}
  \item{na.rm}{logical, indicating whether NA values should be silently removed before the computation proceeds. Default is FALSE.}
}

\value{
a data frame
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{agg.wtd.var}}
}

\examples{
data(Movies)
agg.wtd.mean(Movies[,c("Critics", "BoxOffice")], by = Movies$Country)
}

\keyword{ multivariate }
\keyword{ misc }
