\name{print.desk}
\alias{print.desk}
\title{Alternative Console Output for Regression- and Test-results}
\usage{
\method{print}{desk}(x, details, digits = 4, ...)
}
\arguments{
\item{x}{object of class desk to be printed to the console.}

\item{details}{logical value indicating whether details of object \code{x} should be printed.}

\item{digits}{number of digits to round to (only output).}

\item{...}{any argument that \code{print()} accepts.}
}
\value{
No return value. Called for side effects.
}
\description{
This function implements an S3 method for printing regression- and test-results generated by functions of the desk package. Used for internal purposes.
}
\examples{
## Simple regression model
tip.est <- ols (y ~ x, data = data.tip)

## Check its class
class(tip.est)
#> [1] "desk" "lm"

## Standard regression output
print(tip.est) # same as tip.est

## Regression output with details rounded to 2 digits
print(tip.est, details = TRUE, digits = 2)

}
\concept{console}
\concept{print}
\concept{regression results}
\concept{test results}
