% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_xor_reportHTML.R
\name{generate_xor_reportHTML}
\alias{generate_xor_reportHTML}
\title{Generate XOR Detection HTML Report}
\usage{
generate_xor_reportHTML(
  results,
  data,
  class_col,
  output_file = "xor_detection_report.html",
  open_browser = TRUE,
  scale_data = TRUE,
  quantile_lines = c(1/3, 2/3),
  line_method = "quantile"
)
}
\arguments{
\item{results}{Either a data frame from \code{detect_xor$results_df} or the full list returned by \code{detect_xor}.}

\item{data}{Original dataset containing variables and classes.}

\item{class_col}{Character specifying the class column name.}

\item{output_file}{Character specifying the output HTML file name. Default: "xor_detection_report.html".}

\item{open_browser}{Logical indicating whether to open the report in browser automatically. Default: TRUE.}

\item{scale_data}{Logical indicating whether to scale variables in plots. Default: TRUE.}

\item{quantile_lines}{Numeric vector of quantiles for reference lines in XY plots. Default: c(1/3, 2/3).}

\item{line_method}{Method for boundary calculation ("quantile" or "range"). Default: "quantile".}
}
\value{
Invisibly returns the file path of the generated HTML report.
}
\description{
Creates an HTML report with formatted table and plots for XOR pattern detection results.
}
\seealso{
\code{\link{detect_xor}} for XOR pattern detection,
\code{\link{generate_xor_reportConsole}} for text-based report generation
}