% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_documentation.R
\docType{data}
\name{wd_pcon_lad_la_rgn_ctry}
\alias{wd_pcon_lad_la_rgn_ctry}
\title{Ward to Constituency to LAD to LA to Region to Country lookup}
\format{
\subsection{\code{wd_pcon_lad_la_rgn_ctry}}{

A data frame with 24,629 rows and 14 columns:
\describe{
\item{first_available_year_included}{
First year in the lookups that we see this location
}
\item{most_recent_year_included}{
Last year in the lookups that we see this location
}
\item{ward_name}{Ward name}
\item{pcon_name}{Parliamentary constituency name}
\item{lad_name}{Local authority district name}
\item{la_name}{Local authority name}
\item{region_name}{Region name}
\item{country_code}{Country name}
\item{ward_code}{9 digit ward code}
\item{pcon_code}{9 digit westminster constituency code}
\item{lad_code}{9 digit local authority district code}
\item{new_la_code}{9 digit local authority code}
\item{region_code}{9 digit region code}
\item{country_code}{9 digit country code}
}
}
}
\source{
https://geoportal.statistics.gov.uk/search?tags=lup_wd_pcon_lad_utla
and https://geoportal.statistics.gov.uk/search?q=lup_wd_lad_cty_rgn_gor_ctry
}
\usage{
wd_pcon_lad_la_rgn_ctry
}
\description{
A lookup showing the hierarchy of ward to Westminster parliamentary
constituency to local authority district to local authority to region to
country for years 2017, 2019, 2020, 2021, 2022, 2023 and 2024.
}
\details{
Changes we've made to the original lookup:
\enumerate{
\item The original lookup from ONS uses the Upper Tier Local Authority, we then
update this so that where there is a metropolitan local authority we use the
local authority district as the local authority to match how
DfE publish data for local authorities.
\item We have noticed that in the 2017 version, the Glasgow East constituency
had a code of S1400030 instead of the usual S14000030, we've assumed this
was an error and have change this in our data so that Glasgow East is
S14000030 in 2017.
\item We have joined on regions using the Ward to LAD to County to Region file.
\item We have joined on countries based on the E / N / S / W at the start of
codes.
\item Scotland had no published regions in 2017, so given the rest of the years
have Scotland as the region, we've forced that in for 2017 too to complete
the data set.
}
}
\keyword{datasets}
